<?php

namespace AppBundle\Service;

use AdminBundle\Repository\CategoryRepository;
use AdminBundle\Repository\ProjectRepository;

class ProjectService {

    /**
     * @var ProjectRepository
     */
    private $_projectRepository;

    /**
     * @var CategoryRepository
     */
    private $_categoryRepository;

    function __construct(ProjectRepository $projectRepository, CategoryRepository $categoryRepository)
    {
        $this->_projectRepository = $projectRepository;
        $this->_categoryRepository = $categoryRepository;
    }


    public function presentProjects($locale) {
        $projects = array();
        foreach($this->_projectRepository->findAllOrderBy() as $project) {
            $translation = $project->getTranslation($locale);
            if(!isset($translation)) {
                continue;
            }

            $p = new \stdClass();
            $p->slug = $project->getSlug();
            $p->categories = $project->getCategories();
            $p->company = $project->getCompany();
            $p->title = $translation->getTitle();
            $p->picture = $project->getPicture();
            $p->animation = $project->getAnimation();
            $p->color = $project->getColor();

            $projects[] = $p;
        }

        return array(
            'projects' => $projects,
            'categories' => $this->_categoryRepository->findAll(),
            'selectedCategory' => 'all'
        );
    }

}