<?php

namespace AppBundle\Form\Handler;


use AdminBundle\Entity\Contact;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Form\Form;
use Symfony\Component\HttpFoundation\Request;

class ContactFormHandler {

    /**
     * @var Form
     */
    protected $form;
    /**
     * @var Request
     */
    protected $request;
    /**
     * @var ContainerInterface
     */
    protected $container;

    function __construct(Form $form, Request $request, ContainerInterface $container)
    {
        $this->form = $form;
        $this->request = $request;
        $this->container = $container;
    }

    /**
     * Process the form
     *
     * @return bool
     */
    public function process() {
        if($this->request->isMethod('post')) {
            $contact = $this->form->getData();
            $this->onSuccess($contact);
            return true;
        }
        return false;
    }

    /**
     * @param Contact $contact
     */
    protected function onSuccess($contact) {
        $entityManager = $this->container->get('doctrine.orm.entity_manager');
        $contact->setCreatedAt(new \DateTime('now'));
        $entityManager->persist($contact);
        $entityManager->flush();
    }

}