<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use FOS\UserBundle\Model\User as BaseUser;

/**
 * Class User
 * @package Entity
 *
 * @ORM\Entity
 * @ORM\Table(name = "user")
 *
 */
class User extends BaseUser {

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @var integer
     */
    protected $id;

    /**
     * @ORM\Column(name="first_name", type="string")
     *
     * @var string
     */
    protected $firstName;

    /**
     * @ORM\Column(name="last_name", type="string")
     *
     * @var string
     */
    protected $lastName;



    function __construct()
    {
        parent::__construct();
        $this->addRole('ROLE_ADMIN');
    }


    /**
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * @param integer $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * @param mixed $firstName
     */
    public function setFirstName($firstName)
    {
        $this->firstName = $firstName;
    }

    /**
     * @return mixed
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    /**
     * @param mixed $lastName
     */
    public function setLastName($lastName)
    {
        $this->lastName = $lastName;
    }

}