<?php

namespace AppBundle\Controller;

use AdminBundle\Entity\Project;
use AppBundle\Helper\LocaleHelper;
use MyProject\Proxies\__CG__\stdClass;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

class ProjectController extends Controller {

    /**
     * @Route("/projects", name="app_projects")
     * @Method("GET")
     * @Template()
     */
    public function indexAction(Request $request) {
        LocaleHelper::initLocale($request);
        return $this->get('project_service')->presentProjects($request->getSession()->get('_locale'));
    }

    /**
     * @Route("/projects/{category}", name="app_projects_category")
     * @Method("GET")
     * @Template("AppBundle:Project:index.html.twig")
     */
    public function projectsCategoryAction($category, Request $request) {
        LocaleHelper::initLocale($request);

        $projectRepository = $this->get('project_repository');
        $projects = array();
        foreach($projectRepository->findAllByCategory($category) as $project) {
            $translation = $project->getTranslation($request->getSession()->get('_locale'));
            if(!isset($translation)) {
                continue;
            }

            $p = new \stdClass();
            $p->slug = $project->getSlug();
            $p->categories = $project->getCategories();
            $p->company = $project->getCompany();
            $p->title = $translation->getTitle();
            $p->picture = $project->getPicture();
            $p->animation = $project->getAnimation();
            $p->color = $project->getColor();

            $projects[] = $p;
        }


        $categoryRepository = $this->get('category_repository');
        return array(
            'projects' => $projects,
            'categories' => $categoryRepository->findAll(),
            'selectedCategory' => $category
        );
    }

    /**
     * @Route("/project/{slug}", name="app_project")
     * @ParamConverter("project", class="AdminBundle\Entity\Project")
     * @Method("GET")
     * @Template()
     */
    public function projectAction(Project $project, Request $request) {
        LocaleHelper::initLocale($request);

        $localeProject = new \stdClass();
        $localeProject->video = $project->getVideo();
        $localeProject->categories = $project->getCategories();
        $localeProject->company = $project->getCompany();
        $localeProject->color = $project->getColor();
        $localeProject->year = $project->getYear();

        $translation = $project->getTranslation($request->getSession()->get('_locale'));
        $localeProject->title = $translation->getTitle();
        $localeProject->description = $translation->getDescription();
        $localeProject->credits = $translation->getCredits();

        $localeProject->siblings = array();
        foreach($project->getSiblings() as $projectSibling) {
            $sibling = new \stdClass();
            $sibling->slug = $projectSibling->getSlug();
            $sibling->company = $projectSibling->getCompany();
            $sibling->picture = $projectSibling->getPicture();
            $sibling->animation = $projectSibling->getAnimation();
            $sibling->color = $projectSibling->getColor();
            $sibling->categories = $projectSibling->getCategories();
            $siblingTransaltion = $projectSibling->getTranslation($request->getSession()->get('_locale'));
            if(isset($siblingTransaltion)) {
                $sibling->title = $siblingTransaltion->getTitle();
            }
            $localeProject->siblings[] = $sibling;
        }
        return array('project' => $localeProject);
    }

}