<?php

namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;

class LocaleController extends Controller {

    /**
     * @Route("/locale/{_locale}", name="app_locale_change")
     * @Method("GET")
     *
     * @param $request
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function localeAction(Request $request)
    {
        $locale = $request->getLocale();
        $request->getSession()->set('_locale', $locale);

        $referer = $request->headers->get('referer');
        if (empty($referer)) {
            return $this->redirect('/');
        }

        return $this->redirect($referer);
    }

}