<?php

namespace AdminBundle\Repository;

use Doctrine\ORM\EntityRepository;

class ProjectRepository extends EntityRepository {

    public function findAllByCategory($category) {
        return $this->createQueryBuilder('p')
            ->select('p')
            ->innerJoin('p.categories', 'c')
            ->where('c.slug = :category')
            ->setParameter('category', $category)
            ->orderBy('p.order')
            ->getQuery()
            ->getResult();
    }

    public function findAllOrderBy() {
        return $this->createQueryBuilder('p')
            ->orderBy('p.order')
            ->getQuery()
            ->getResult();
    }

    public function findLastOrder() {
        return $this->createQueryBuilder('p')
            ->select('p.order')
            ->orderBy('p.order', 'desc')
            ->setMaxResults(1)
            ->getQuery()
            ->getSingleScalarResult();
    }

}