<?php
namespace AdminBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ProjectTranslationFormType extends AbstractType {

    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder->add('language', 'entity', array(
            'class' => 'AdminBundle:Language',
            'choice_label' => 'label',
        ));
        $builder->add('title', 'text', array(
            'label' => 'Titre',
            'required' => true
        ));
        $builder->add('description', 'textarea', array(
            'label' => 'Description',
            'required' => false
        ));
        $builder->add('credits', 'collection', array(
            'type' => new ProjectCreditFormType(),
            'allow_add' => true,
            'allow_delete' => true,
            'prototype_name' => '__credit_name__'
        ));
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => "AdminBundle\Form\ProjectTranslationForm",
            'csrf_protection' => false
        ));
    }

    public function getName()
    {
        return 'admin_project_translation_form';
    }

}