<?php

namespace AdminBundle\Form\Type;


use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ProjectFormType extends AbstractType {

    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder->add('id', 'hidden');
        $builder->add('slug', 'text', array(
            'label' => 'Slug (pour affichage dans URL, ex: mon-projet-pour-societe)',
            'required' => true
        ));
        $builder->add('company', 'text', array(
            'label' => 'Société',
            'required' => true
        ));
        $builder->add('year', 'text', array(
            'label' => 'Année',
            'required' => true
        ));
        $builder->add('picture', 'file', array(
            'label' => 'Image',
            'required' => false
        ));
        $builder->add('animation', 'file', array(
            'label' => 'Animation',
            'required' => false
        ));
        $builder->add('video', 'text', array(
            'label' => 'Lien vidéo',
            'required' => false
        ));
        $builder->add('color', 'text', array(
            'label' => 'Couleur',
            'required' => true
        ));
        $builder->add('categories', 'entity', array(
            'label' => 'Catégories',
            'class' => 'AdminBundle:Category',
            'choice_label' => 'label',
            'expanded' => true,
            'multiple' => true
        ));
        $builder->add('translations', 'collection', array(
            'type' => new ProjectTranslationFormType(),
            'allow_add' => true,
            'allow_delete' => true,
            'prototype_name' => '__translation_name__'
        ));
        $builder->add('siblings', 'entity', array(
            'label' => 'Projets similaires',
            'class' => 'AdminBundle:Project',
            'choice_label' => 'slug',
            'multiple' => true
        ));
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => "AdminBundle\Form\ProjectForm"
        ));
    }

    public function getName()
    {
        return 'admin_project_form';
    }

}