<?php
namespace AdminBundle\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ProjectCreditFormType extends AbstractType {

    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder->add('position', 'text', array(
            'label' => 'Position',
            'required' => true
        ));
        $builder->add('label', 'text', array(
            'label' => 'Label',
            'required' => true
        ));
        $builder->add('value', 'text', array(
            'label' => 'Valeur',
            'required' => true
        ));
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => "AdminBundle\Form\ProjectCreditForm",
            'csrf_protection' => false
        ));
    }

    public function getName()
    {
        return 'admin_project_credit_form';
    }

}