<?php

namespace AdminBundle\Form;


use AdminBundle\Entity\ProjectTranslation;

class ProjectTranslationForm {

    private $language;
    private $title;
    private $description;
    private $credits;

    function __construct(ProjectTranslation $projectTranslation = null)
    {
        if(isset($projectTranslation)) {
            $this->language = $projectTranslation->getLanguage();
            $this->title = $projectTranslation->getTitle();
            $this->description = $projectTranslation->getDescription();

            $this->credits = array();
            foreach($projectTranslation->getCredits() as $credit) {
                $this->credits[] = new ProjectCreditForm($credit);
            }
        }
    }

    /**
     * @return mixed
     */
    public function getLanguage()
    {
        return $this->language;
    }

    /**
     * @param mixed $language
     */
    public function setLanguage($language)
    {
        $this->language = $language;
    }

    /**
     * @return mixed
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param mixed $title
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }

    /**
     * @return mixed
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param mixed $description
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }

    /**
     * @return mixed
     */
    public function getCredits()
    {
        return $this->credits;
    }

    /**
     * @param mixed $credits
     */
    public function setCredits($credits)
    {
        $this->credits = $credits;
    }

}