<?php

namespace AdminBundle\Form;


use AdminBundle\Entity\Project;

class ProjectForm {

    private $id;
    private $slug;
    private $color;
    private $company;
    private $year;
    private $picture;
    private $animation;
    private $video;
    private $categories;
    private $siblings;
    private $translations;

    function __construct(Project $project = null)
    {
        $this->translations = array();
        if(isset($project)) {
            $this->id = $project->getId();
            $this->slug = $project->getSlug();
            $this->color = $project->getColor();
            $this->company = $project->getCompany();
            $this->year = $project->getYear();
            $this->video = $project->getVideo();
            $this->categories = $project->getCategories();
            $this->siblings = $project->getSiblings();

            foreach($project->getTranslations() as $translation) {
                $this->translations[] = new ProjectTranslationForm($translation);
            }
        }
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param mixed $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getSlug()
    {
        return $this->slug;
    }

    /**
     * @param mixed $slug
     */
    public function setSlug($slug)
    {
        $this->slug = $slug;
    }

    /**
     * @return mixed
     */
    public function getColor()
    {
        return $this->color;
    }

    /**
     * @param mixed $color
     */
    public function setColor($color)
    {
        $this->color = $color;
    }

    /**
     * @return mixed
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * @param mixed $company
     */
    public function setCompany($company)
    {
        $this->company = $company;
    }

    /**
     * @return mixed
     */
    public function getYear()
    {
        return $this->year;
    }

    /**
     * @param mixed $year
     */
    public function setYear($year)
    {
        $this->year = $year;
    }

    /**
     * @return mixed
     */
    public function getPicture()
    {
        return $this->picture;
    }

    /**
     * @param mixed $picture
     */
    public function setPicture($picture)
    {
        $this->picture = $picture;
    }

    /**
     * @return mixed
     */
    public function getAnimation()
    {
        return $this->animation;
    }

    /**
     * @param mixed $animation
     */
    public function setAnimation($animation)
    {
        $this->animation = $animation;
    }

    /**
     * @return mixed
     */
    public function getVideo()
    {
        return $this->video;
    }

    /**
     * @param mixed $video
     */
    public function setVideo($video)
    {
        $this->video = $video;
    }

    /**
     * @return mixed
     */
    public function getCategories()
    {
        return $this->categories;
    }

    /**
     * @param mixed $categories
     */
    public function setCategories($categories)
    {
        $this->categories = $categories;
    }

    /**
     * @return mixed
     */
    public function getSiblings()
    {
        return $this->siblings;
    }

    /**
     * @param mixed $siblings
     */
    public function setSiblings($siblings)
    {
        $this->siblings = $siblings;
    }

    /**
     * @return mixed
     */
    public function getTranslations()
    {
        return $this->translations;
    }

    /**
     * @param mixed $translations
     */
    public function setTranslations($translations)
    {
        $this->translations = $translations;
    }

    public function addTranslation(ProjectTranslationForm $translation) {
        $this->translations[] = $translation;
    }



}