<?php

namespace AdminBundle\Form\Handler;


use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Form\Form;
use Symfony\Component\HttpFoundation\Request;

class StudioFormHandler {

    /**
     * @var Form
     */
    protected $form;
    /**
     * @var Request
     */
    protected $request;
    /**
     * @var ContainerInterface
     */
    protected $container;

    function __construct(Form $form, Request $request, ContainerInterface $container)
    {
        $this->form = $form;
        $this->request = $request;
        $this->container = $container;
    }

    /**
     * Process the form
     *
     * @return bool
     */
    public function process() {
        if($this->request->isMethod('post')) {
            $studio = $this->form->getData();
            $this->onSuccess($studio);
            return true;
        }
        return false;
    }

    protected function onSuccess($studio) {
        $entityManager = $this->container->get('doctrine.orm.entity_manager');
        $entityManager->persist($studio);
        $entityManager->flush();
    }

}