<?php

namespace AdminBundle\Form\Handler;


use AdminBundle\Entity\Project;
use AdminBundle\Entity\ProjectCredit;
use AdminBundle\Entity\ProjectTranslation;
use AdminBundle\Form\ProjectForm;
use AdminBundle\Helper\GuidHelper;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Form\Form;
use Symfony\Component\HttpFoundation\Request;

class ProjectFormHandler {

    /**
     * @var Form
     */
    protected $form;
    /**
     * @var Request
     */
    protected $request;
    /**
     * @var ContainerInterface
     */
    protected $container;

    function __construct(Form $form, Request $request, ContainerInterface $container)
    {
        $this->form = $form;
        $this->request = $request;
        $this->container = $container;
    }

    /**
     * Process the form
     *
     * @return bool
     */
    public function process() {
        if($this->request->isMethod('post')) {
            $data = $this->form->getData();
            $this->onSuccess($data);
            return true;
        }
        return false;
    }

    /**
     * @param ProjectForm $data
     */
    protected function onSuccess($data) {
        $project = new Project();
        $project->setColor($data->getColor());
        $project->setCompany($data->getCompany());
        $project->setSlug($data->getSlug());
        $project->setVideo($data->getVideo());
        $project->setYear($data->getYear());

        $project->setCategories($data->getCategories());
        $project->setSiblings($data->getSiblings());

        $projectRepository = $this->container->get('project_repository');
        $lastOrder = $projectRepository->findLastOrder();
        $project->setOrder($lastOrder + 1);

        foreach($data->getTranslations() as $translationData) {
            $translation = new ProjectTranslation();
            $translation->setLanguage($translationData->getLanguage());
            $translation->setDescription($translationData->getDescription());
            $translation->setProject($project);
            $translation->setTitle($translationData->getTitle());

            foreach($translationData->getCredits() as $creditData) {
                $credit = new ProjectCredit();
                $credit->setLabel($creditData->getLabel());
                $credit->setPosition($creditData->getPOsition());
                $credit->setValue($creditData->getValue());
                $credit->setProjectTranslation($translation);
                $translation->addCredit($credit);
            }
            $project->addTranslation($translation);
        }

        if(null !== $data->getPicture() || null !== $project->getAnimation()) {
            $folder = GuidHelper::GUID();
            $output = __DIR__ . '/../../../../web/uploads/projects/' . $folder;
            if(!is_dir($output)) {
                mkdir($output);
            }
            if(null !== $data->getPicture()) {
                $picture = $data->getPicture();
                $fileName = 'picture.' . $picture->guessExtension();
                $picture->move($output, $fileName);
                $project->setPicture('/uploads/projects/' . $folder .'/' . $fileName);
            }
            if(null !== $data->getAnimation()) {
                $animation = $data->getAnimation();
                $fileName = 'animation.' . $animation->guessExtension();
                $animation->move($output, $fileName);
                $project->setAnimation('/uploads/projects/' . $folder . '/' . $fileName);
            }
        }

        $entityManager = $this->container->get('doctrine.orm.entity_manager');
        $entityManager->persist($project);
        $entityManager->flush();
    }

}