<?php

namespace AdminBundle\Form\Handler;


use AdminBundle\Entity\Category;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Form\Form;
use Symfony\Component\HttpFoundation\Request;

class CategoryFormHandler {

    /**
     * @var Form
     */
    protected $form;
    /**
     * @var Request
     */
    protected $request;
    /**
     * @var ContainerInterface
     */
    protected $container;

    function __construct(Form $form, Request $request, ContainerInterface $container)
    {
        $this->form = $form;
        $this->request = $request;
        $this->container = $container;
    }

    /**
     * Process the form
     *
     * @return bool
     */
    public function process() {
        if($this->request->isMethod('post')) {
            $category = $this->form->getData();
            $this->onSuccess($category);
            return true;
        }
        return false;
    }

    /**
     * @param Category $category
     */
    protected function onSuccess($category) {
        $entityManager = $this->container->get('doctrine.orm.entity_manager');
        if(null === $category->getId()) {
            $entityManager->persist($category);
        } else {
            $entityManager->merge($category);
        }
        $entityManager->flush();
    }

}