<?php

namespace AdminBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Class ProjectCredit
 * @package AdminBundle\Entity
 *
 * @ORM\Entity
 * @ORM\Table(name="project_credit")
 */
class ProjectCredit {

    /**
     * @ORM\Id
     * @ORM\Column(name="id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @var integer
     */
    private $id;

    /**
     * @ORM\Column(name="position", type="integer", length=11, nullable=false)
     *
     * @var int
     */
    private $position;

    /**
     * @ORM\Column(name="label", type="string", length=255)
     * @var string
     */
    private $label;

    /**
     * @ORM\Column(name="value", type="string", length=255)
     * @var string
     */
    private $value;

    /**
     * @ORM\ManyToOne(targetEntity="ProjectTranslation", inversedBy="credits")
     * @ORM\JoinColumn(name="project_translation_id", referencedColumnName="id", nullable=false)
     *
     * @var ProjectTranslation
     */
    private $projectTranslation;


    function __construct()
    {
        $this->position = 1;
    }


    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * @param string $label
     */
    public function setLabel($label)
    {
        $this->label = $label;
    }

    /**
     * @return string
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param string $value
     */
    public function setValue($value)
    {
        $this->value = $value;
    }

    /**
     * @return int
     */
    public function getPosition()
    {
        return $this->position;
    }

    /**
     * @param int $position
     */
    public function setPosition($position)
    {
        $this->position = $position;
    }

    /**
     * @return ProjectTranslation
     */
    public function getProjectTranslation()
    {
        return $this->projectTranslation;
    }

    /**
     * @param ProjectTranslation $projectTranslation
     */
    public function setProjectTranslation($projectTranslation)
    {
        $this->projectTranslation = $projectTranslation;
    }

}