<?php

namespace AdminBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;

/**
 * Class Project
 * @package AdminBundle\Entity
 *
 * @ORM\Entity(repositoryClass="AdminBundle\Repository\ProjectRepository")
 * @ORM\Table(name="project")
 */
class Project {

    /**
     * @ORM\Id
     * @ORM\Column(name="id", type="integer", length=11)
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @var integer
     */
    private $id;

    /**
     * @ORM\Column(name="ordering", type="integer", nullable=false)
     *
     * @var integer
     */
    private $order;

    /**
     * @ORM\Column(name="slug", type="string", length=255, unique=true, nullable=false)
     */
    private $slug;

    /**
     * @ORM\Column(name="color", type="string", length=6, nullable=false)
     *
     * @var string
     */
    private $color;

    /**
     * @ORM\Column(name="company", type="string", length=100, nullable=false)
     * @var string
     */
    private $company;

    /**
     * @ORM\Column(name="year", type="integer", length=11, nullable=false)
     * @var int
     */
    private $year;

    /**
     * @ORM\Column(name="picture", type="string", length=100, nullable=false)
     *
     * @var mixed
     */
    private $picture;

    /**
     * @ORM\Column(name="animation", type="string", length=100, nullable=true)
     *
     * @var mixed
     */
    private $animation;

    /**
     * @ORM\Column(name="video", type="string", length=255, nullable=true)
     *
     * @var string
     */
    private $video;

    /**
     * @ORM\ManyToMany(targetEntity="AdminBundle\Entity\Category", inversedBy="events")
     * @ORM\JoinTable(name="events_categories")
     *
     * @var ArrayCollection
     */
    private $categories;

    /**
     * @ORM\OneToMany(targetEntity="ProjectTranslation", mappedBy="project", cascade={"persist", "remove"}, orphanRemoval=true)
     *
     * @var ArrayCollection
     */
    private $translations;

    /**
     * @ORM\ManyToMany(targetEntity="AdminBundle\Entity\Project")
     * @ORM\JoinTable(name="projects_siblings")
     *
     * @var ArrayCollection
     */
    private $siblings;




    function __construct()
    {
        $this->categories = new ArrayCollection();
        $this->translations = new ArrayCollection();
    }


    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     * @return mixed
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @param mixed $order
     */
    public function setOrder($order)
    {
        $this->order = $order;
    }

    /**
     * @return mixed
     */
    public function getSlug()
    {
        return $this->slug;
    }

    /**
     * @param mixed $slug
     */
    public function setSlug($slug)
    {
        $this->slug = $slug;
    }

    /**
     * @return string
     */
    public function getColor()
    {
        return $this->color;
    }

    /**
     * @param string $color
     */
    public function setColor($color)
    {
        $this->color = $color;
    }

    /**
     * @return string
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * @param string $company
     */
    public function setCompany($company)
    {
        $this->company = $company;
    }

    /**
     * @return int
     */
    public function getYear()
    {
        return $this->year;
    }

    /**
     * @param int $year
     */
    public function setYear($year)
    {
        $this->year = $year;
    }

    /**
     * @return mixed
     */
    public function getPicture()
    {
        return $this->picture;
    }

    /**
     * @param mixed $picture
     */
    public function setPicture($picture)
    {
        $this->picture = $picture;
    }

    /**
     * @return mixed
     */
    public function getAnimation()
    {
        return $this->animation;
    }

    /**
     * @param mixed $animation
     */
    public function setAnimation($animation)
    {
        $this->animation = $animation;
    }

    /**
     * @return string
     */
    public function getVideo()
    {
        return $this->video;
    }

    /**
     * @param string $video
     */
    public function setVideo($video)
    {
        $this->video = $video;
    }

    /**
     * @return mixed
     */
    public function getCategories()
    {
        return $this->categories;
    }

    /**
     * @param mixed $categories
     */
    public function setCategories($categories)
    {
        $this->categories = $categories;
    }

    public function removeCategories() {
        $this->categories->clear();
    }

    /**
     * @return ArrayCollection[ProjectTranslation]
     */
    public function getTranslations()
    {
        return $this->translations;
    }

    /**
     * @param string $code
     * @return ProjectTranslation
     */
    public function getTranslation($code = 'fr') {
        foreach($this->translations as $translation) {
            if($code === $translation->getLanguage()->getIsoCode()) {
                return $translation;
            }
        }
        return null;
    }

    /**
     * @param ArrayCollection $translations
     */
    public function setTranslations($translations)
    {
        $this->translations = $translations;
    }

    public function addTranslation(ProjectTranslation $translation) {
        $this->translations->add($translation);
    }

    public function removeTranslations() {
        $this->translations->clear();
    }

    /**
     * @return ArrayCollection
     */
    public function getSiblings()
    {
        return $this->siblings;
    }

    /**
     * @param ArrayCollection $siblings
     */
    public function setSiblings($siblings)
    {
        $this->siblings = $siblings;
    }

}