<?php

namespace AdminBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Class Language
 * @package AdminBundle\Entity
 *
 * @ORM\Entity(repositoryClass="AdminBundle\Repository\LanguageRepository")
 * @ORM\Table(name="language")
 */
class Language {

    /**
     * @ORM\Id
     * @ORM\Column(name="iso_code", type="string", length=3)
     *
     * @var string
     */
    private $isoCode;

    /**
     * @ORM\Column(name="label", type="string", length=25)
     *
     * @var string
     */
    private $label;

    /**
     * @return string
     */
    public function getIsoCode()
    {
        return $this->isoCode;
    }

    /**
     * @param string $isoCode
     */
    public function setIsoCode($isoCode)
    {
        $this->isoCode = $isoCode;
    }

    /**
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * @param string $label
     */
    public function setLabel($label)
    {
        $this->label = $label;
    }

}