<?php
namespace AdminBundle\Controller;

use AdminBundle\Entity\Studio;
use AdminBundle\Form\Handler\StudioFormHandler;
use AdminBundle\Form\Type\StudioFormType;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Component\HttpFoundation\Request;

class StudioController extends Controller {

    /**
     * @Route("/studio", name="admin_studio")
     * @Method("GET")
     * @Template("AdminBundle:Studio:index.html.twig")
     */
    public function displayStudioAction() {
        $forms = array();
        $repository = $this->get('studio_repository');
        foreach($repository->findAll() as $studio) {
            $form = $this->createForm(new StudioFormType(), $studio);
            $forms[] = array(
                "id" => $studio->getId(),
                "form" => $form->createView()
            );
        }
        return array('forms' => $forms);
    }

    /**
     * @Route("/studio/{id}/save", name="admin_studio_save")
     * @ParamConverter("studio", class="AdminBundle\Entity\Studio")
     * @Method("POST")
     */
    public function saveStudioAction(Request $request, Studio $studio) {
        $form = $this->createForm(new StudioFormType(), $studio);
        $form->handleRequest($request);

        if($form->isValid()) {
            $handler = new StudioFormHandler($form, $request, $this->container);
            $handler->process();
        }
        return $this->redirect($this->generateUrl('admin_studio'));
    }



}