<?php

namespace AdminBundle\Controller;

use AdminBundle\Entity\Project;
use AdminBundle\Form\Handler\ProjectEditionFormHandler;
use AdminBundle\Form\Handler\ProjectFormHandler;
use AdminBundle\Form\ProjectForm;
use AdminBundle\Form\ProjectTranslationForm;
use AdminBundle\Form\Type\ProjectFormType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

class ProjectController extends Controller {

    /**
     * @Route("/projects", name="admin_projects")
     * @Method("GET")
     * @Template("AdminBundle:Project:index.html.twig")
     */
    public function displayAction() {
        $repository = $this->get('project_repository');

        $projects = array();
        foreach($repository->findAllOrderBy() as $project) {
            $p = new \stdClass();
            $p->id = $project->getId();
            $p->company = $project->getCompany();
            if(null !== $project->getTranslation()) {
                $p->title = $project->getTranslation()->getTitle();
            }
            $projects[] = $p;
        }

        return array('projects' => $projects);
    }

    /**
     * @Route("/project/create", name="admin_project_create")
     * @Method({"GET","POST"})
     * @Template()
     */
    public function createAction(Request $request) {
        $project = new ProjectForm();
        $languageRepository = $this->get('language_repository');
        foreach($languageRepository->findAll() as $language) {
            $translation = new ProjectTranslationForm();
            $translation->setLanguage($language);
            $project->addTranslation($translation);
        }
        $form = $this->createForm(new ProjectFormType(), $project);
        $form->handleRequest($request);

        $handler = new ProjectFormHandler($form, $request, $this->container);
        if($form->isValid() && $handler->process()) {
            return $this->redirect($this->generateUrl('admin_projects'));
        }
        return array('form' => $form->createView());
    }

    /**
     * @Route("/project/{id}/edit", name="admin_project_edit")
     * @ParamConverter("project", class="AdminBundle\Entity\Project")
     * @Method({"GET","POST"})
     * @Template()
     */
    public function editAction(Request $request, Project $project) {
        $projectForm = new ProjectForm($project);

        $form = $this->createForm(new ProjectFormType(), $projectForm);
        $form->handleRequest($request);

        $handler = new ProjectEditionFormHandler($form, $request, $this->container);
        if($form->isValid() && $handler->process($project)) {
            return $this->redirect($this->generateUrl('admin_projects'));
        }
        return array('form' => $form->createView(), 'id' => $project->getId());
    }

    /**
     * @Route("/project/delete/{id}", name="admin_project_delete")
     * @ParamConverter("project", class="AdminBundle\Entity\Project")
     * @Method("GET")
     */
    public function deleteAction(Project $project) {
        $entityManager = $this->get('doctrine.orm.entity_manager');
        $entityManager->remove($project);
        $entityManager->flush();

        return $this->redirect($this->generateUrl('admin_projects'));
    }

    /**
     * @Route("/project/ordering", name="admin_project_ordering")
     * @Method("POST")
     */
    public function orderPicturesAction(Request $request) {
        $ordering = $request->request->get('projects');

        $repository = $this->get('project_repository');
        foreach($repository->findAll() as $project) {
            $project->setOrder($ordering[$project->getId()]);
        }
        $entityManager = $this->get('doctrine.orm.entity_manager');
        $entityManager->flush();

        return new JsonResponse(array());
    }

}